function ctrl = designEffShiftLogic(veh, plots)
arguments
    veh
    plots = false;
end

% User settings
ctrl.shiftMinTime = 2; % s
ctrl.downshiftDelay = 6; % s
ctrl.upshiftDelay = 6; % s
ctrl.ratioEarlyUp = 24;
ctrl.ratioEarlyDown = 24;
ctrl.maxGearSkip = 2; % Maximum skippable gears
ctrl.trqRes = 0; % Torque reserve for efficiency shifts
ctrl.effHyst = 0.97;

% Identify shift polygons
maxTrqCurve = @(x) veh.eng.maxTrq(x);
[spd_maxTrq, maxTrq] = fminbnd(@(x) -maxTrqCurve(x), veh.eng.idleSpd, veh.eng.maxSpd);
maxTrq = -maxTrq;

maxPwrCurve = @(spd) veh.eng.maxTrq(spd) .* spd;
[spd_maxPwr, maxPwr] = fminbnd(@(x) -maxPwrCurve(x), veh.eng.idleSpd, veh.eng.maxSpd);
maxPwr = -maxPwr;

% Identify n_T99
idx = find(veh.eng.maxTrq.Values > 0.99 * maxTrq, 1, 'first');
T_r = veh.eng.maxTrq.Values(idx);
T_l = veh.eng.maxTrq.Values(idx-1);
n_r = veh.eng.maxTrq.GridVectors{1}(idx);
n_l = veh.eng.maxTrq.GridVectors{1}(idx-1);
n_T99 = n_l + ( 0.99*maxTrq - T_l ) / ( T_r - T_l ) * ( n_r - n_l );

% Identify n_P98
pwrBrk = veh.eng.maxTrq.Values .* veh.eng.maxTrq.GridVectors{1};
idx = ( pwrBrk(1:end-1) > 0.98 * maxPwr ) & ( pwrBrk(2:end) < 0.98 * maxPwr );
idx = find(idx) + 1;
if length(idx) > 1
    error("?")
end
n_r = veh.eng.maxTrq.GridVectors{1}(idx);
n_l = veh.eng.maxTrq.GridVectors{1}(idx-1);
P_r = veh.eng.maxTrq.Values(idx) .* n_r;
P_l = veh.eng.maxTrq.Values(idx-1) .* n_l;
n_P98h = n_l + ( 0.98*maxPwr - P_l ) / ( P_r - P_l ) * ( n_r - n_l );
if isempty(n_P98h)
    n_P98h = veh.eng.maxSpd;
end

% Identify n_T98
idx = ( veh.eng.maxTrq.Values(1:end-1) > 0.98 * maxTrq ) & ( veh.eng.maxTrq.Values(2:end) < 0.98 * maxTrq );
idx = find(idx) + 1;
if length(idx) > 1
    error("?")
end
n_r = veh.eng.maxTrq.GridVectors{1}(idx);
n_l = veh.eng.maxTrq.GridVectors{1}(idx-1);
T_r = veh.eng.maxTrq.Values(idx);
T_l = veh.eng.maxTrq.Values(idx-1);
n_T98h = n_l + ( 0.98*maxTrq - T_l ) / ( T_r - T_l ) * ( n_r - n_l );
if isempty(n_T98h)
    n_T98h = veh.eng.maxSpd;
end
% Store
ctrl.n_1 = veh.eng.idleSpd * 1.1;
ctrl.n_T99 = n_T99;
ctrl.n_P98h = n_P98h;
ctrl.n_T98h = n_T98h;

if plots
    figure
    yyaxis left
    hold on
    fplot(maxTrqCurve, [veh.eng.idleSpd, veh.eng.maxSpd])

    yyaxis right
    hold on
    fplot(maxPwrCurve, [veh.eng.idleSpd, veh.eng.maxSpd])

    yyaxis left
    plot([n_T99, n_T99], [0, 0.99*maxTrq], 'k--');
    plot([n_T98h, n_T98h], [0, 0.98*maxTrq], 'k--');

    yyaxis right
    plot([n_P98h, n_P98h], [0, 0.98*maxPwr], 'k--');

    yyaxis left
    ax = gca;
    [ax.XTick, idx] = sort([veh.eng.idleSpd, n_T99, n_T98h, n_P98h, veh.eng.maxSpd]);
    labels = ["n_{idle}", "n_{T99}", "n_{T98h}", "n_{P98h}", "n_{max}"];
    ax.XTickLabel = labels(idx);
end

end
